/*
   When this program runs as a Java child process, its
   standard output streams will be connected to buffers,
   but no process will be emptying those buffers. If the
   parent process reads the stderr stream, it can get a
   count of how many characters were written to the stdout
   stream. When the stream of characters to stderr stops,
   that means that the stdout buffer is full and
   System.out.print() has blocked. The last number read
   from stderr is a count of the stdout buffer size.
*/
import java.io.*;

public class Ex1_OutputBufferCounter_Child
{
   public static void main(String[] args)
   {
      final int BUFFER_SIZE = 1;       // This adds ADDITIONAL buffer space to that
      System.setOut(new PrintStream(  // already in the PrintStream object.
                        new BufferedOutputStream(
                            new FileOutputStream(FileDescriptor.out), BUFFER_SIZE), true));

      int counter = 1;
      while (true)
      {
         System.err.println( counter++ );
         System.out.print("a"); // Don't use println()! Otherwise the count will be inaccurate.
         //System.out.flush();
      }
   }
}